/*******************************************************
Filename		:  	DW_blob_handler.java
Release 		:  	STORET c2.0.1
SIR			:  	1559
Description		:  	Save Oracle BLOBs as files in the specified directory.
Author			:  	Joseph Wilson
Date			: 	October 8, 2003
				11-10-2003 -- moved java permission grants to DW_GRANTS_AND_SYNS -JW
Comments		:  	Requires file io permissions to the target directory.
**********************************************************/

SET DEF OFF;

--BLOB i/o procedure written in java
CREATE OR REPLACE JAVA SOURCE NAMED "BlobHandler" AS
import java.lang.*;
import java.sql.*;
import oracle.sql.*;
import java.io.*;

public class BlobHandler
{
  
  public static void ExportBlob(String myFile, BLOB myBlob) throws Exception
  {
    // Bind the image object to the database object
    // Open streams for the output file and the blob
    File binaryFile = new File(myFile);
    FileOutputStream outStream = new FileOutputStream(binaryFile);
    InputStream inStream = myBlob.getBinaryStream();

    // Get the optimum buffer size and use this to create the read/write buffer
    int size = myBlob.getBufferSize();
    byte[] buffer = new byte[size];
    int length = -1;

    // Transfer the data
    while ((length = inStream.read(buffer)) != -1)
    {
      outStream.write(buffer, 0, length);
      outStream.flush();
    }

    // Close everything down
    inStream.close();
    outStream.close();
  } 

};
/
ALTER java source "BlobHandler" compile;
show errors java source "BlobHandler"
/

--pl/sql wrapper for java code
CREATE OR REPLACE PROCEDURE ExportBlob (p_file  IN  VARCHAR2,
                                        p_blob  IN  BLOB)
AS LANGUAGE JAVA 
NAME 'BlobHandler.ExportBlob(java.lang.String, oracle.sql.BLOB)';
/


/**
--Grant JAVA permissions to report directory
EXEC Dbms_Java.Grant_Permission( -
'STORETW', -
'java.io.FilePermission', -
'/project/storet/modern/downloads/*', -
'read ,write, execute, delete');

--Grant JAVA permissions to report directory --DEV
EXEC Dbms_Java.Grant_Permission( -
'WEB_USER', -
'java.io.FilePermission', -
'/project/storet/moderndev/downloads/*', -
'read ,write, execute, delete');
**/
